<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    
    require 'PHPMailer/src/Exception.php';
    require 'PHPMailer/src/PHPMailer.php';
    require 'PHPMailer/src/SMTP.php';
    
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\SMTP;
    use PHPMailer\PHPMailer\Exception;
    
    header("Content-Type: application/json");
    
    // Handle OPTIONS request (for CORS preflight)
    if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
        header("Access-Control-Allow-Origin: *"); // Adjust for production!
        header("Access-Control-Allow-Methods: POST");
        header("Access-Control-Allow-Headers: Content-Type");
        header("Access-Control-Max-Age: 86400");
        http_response_code(200);
        exit;
    }
    
    // Only allow POST requests
    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        http_response_code(405); // Method Not Allowed
        echo json_encode(["message" => "Method Not Allowed"]);
        exit;
    }
    
    // Get JSON input
    $data = json_decode(file_get_contents("php://input"), true);
    $errors = [];
    
    // Server-side validation
    if (empty($data['firstName'])) $errors['firstName'] = "First Name is required";
    if (empty($data['lastName'])) $errors['lastName'] = "Last Name is required";
    if (empty($data['email']) || !filter_var($data['email'], FILTER_VALIDATE_EMAIL)) $errors['email'] = "Valid email is required";
    if (empty($data['mobile'])) $errors['mobile'] = "Mobile Number is required";
    if (empty($data['destination']) || !is_array($data['destination'])) $errors['destination'] = "Destination is required";
    if (empty($data['tripType'])) $errors['tripType'] = "Trip Type is required";
    if (empty($data['duration'])) $errors['duration'] = "Duration is required";
    if (empty($data['budget'])) $errors['budget'] = "Budget is required";
    if (empty($data['travelDate'])) $errors['travelDate'] = "Travel Date is required";
    if (empty($data['preferences'])) $errors['preferences'] = "Preferences are required";
    if (!isset($data['termsAgreed']) || !$data['termsAgreed']) $errors['termsAgreed'] = "You must agree to the terms";
    
    // Return errors if any
    if (!empty($errors)) {
        http_response_code(400);
        echo json_encode(['errors' => $errors]);
        exit;
    }
    
    // Data sanitization
    $firstName = htmlspecialchars($data['firstName']);
    $lastName = htmlspecialchars($data['lastName']);
    $email = htmlspecialchars($data['email']);
    $mobile = htmlspecialchars($data['mobile']);
    $destination = implode(", ", array_column($data['destination'], 'label'));
    $tripType = htmlspecialchars($data['tripType']);
    $travelDate = htmlspecialchars($data['travelDate']);
    $duration = htmlspecialchars($data['duration']);
    $budget = htmlspecialchars($data['budget']);
    $adults = intval($data['adults']);
    $children = intval($data['children']);
    $childrenAges = htmlspecialchars($data['childrenAges']);
    $preferences = htmlspecialchars($data['preferences']);
    ///$countryCode = htmlspecialchars($data['countryCode']);
    $termsAgreed = $data['termsAgreed'] ? "Yes" : "No";
    ///$budgetPerPerson = isset($data['budgetPerPerson']) ? htmlspecialchars($data['budgetPerPerson']) : "Not specified";
    
    // Construct HTML email body
    $htmlBody = "
        <!DOCTYPE html>
        <html>
        <head>
        <title>Safari Proposal Request</title>
        </head>
        <body>
        <h1>Safari Proposal Request</h1>
        
        <p><strong>Travel Information:</strong></p>
        <ul>
        <li><strong>Destination:</strong> {$destination}</li>
        <li><strong>Trip Type:</strong> {$tripType}</li>
        <li><strong>Travel Date:</strong> {$travelDate}</li>
        <li><strong>Duration:</strong> {$duration}</li>
        <li><strong>Budget per person:</strong> {$budget}</li>
        </ul>
        
        <p><strong>Travelers & Ages:</strong></p>
        <ul>
        <li><strong>Adults:</strong> {$adults}</li>
        <li><strong>Children:</strong> {$children}</li>
        <li><strong>Children Ages:</strong> {$childrenAges}</li>
        </ul>
        
        <p><strong>Preferences:</strong><br>{$preferences}</p>
        
        <p><strong>Contact Details:</strong></p>
        <ul>
        <li><strong>First Name:</strong> {$firstName}</li>
        <li><strong>Last Name:</strong> {$lastName}</li>
        <li><strong>Email:</strong> {$email}</li>
        <li><strong>Mobile:</strong> {$mobile}</li>
        </ul>
        <p><strong>Terms Agreed:</strong> {$termsAgreed}</p>
        </body>
        </html>";
    
    // var_dump($htmlBody);
    // die();

    // Send email using PHPMailer
    $mail = new PHPMailer(true);
    
    try {
        // SMTP Configuration
        $mail->isSMTP();
        $mail->Host = 'mail.valleysafaris.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'admin@valleysafaris.com';
        $mail->Password = 'OYqKhNmc4evc5';///getenv('SMTP_PASSWORD'); @Valley.Safari.2O25//
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; 
        $mail->Port = 465;
    
        // Recipients
        $mail->setFrom('admin@valleysafaris.com', 'Valley Safaris');
        $mail->addAddress('Bantulouto1@gmail.com', 'Valley Safaris');
        $mail->addAddress('micahlordia@gmail.com', 'Valley Safaris');
    
        // Email Content
        $mail->isHTML(true);
        $mail->Subject = 'New Safari Request';
        $mail->Body = $htmlBody;
    
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER; 
        // Send the email
        $mail->send();
        echo json_encode(['message' => 'Email sent successfully']);
    } catch (Exception $e) {
        http_response_code(500);
        error_log("Mail error: " . $mail->ErrorInfo); // Log error to the server logs
        echo json_encode(['message' => 'Error sending email. Please try again later.'.$mail->ErrorInfo]);
    }
?>
